/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.selector;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.utils.presets.PresettedList;
import ivorius.reccomplex.world.gen.feature.selector.EnvironmentalSelection;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.generic.WeightedBiomeMatcher;
import ivorius.reccomplex.world.gen.feature.structure.generic.WeightedDimensionMatcher;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class StructureSelector<T extends GenerationType, C> {
    protected final Set<String> cachedDimensionTypes = new HashSet<String>();
    protected Multimap<C, WeightedSelector.SimpleItem<Pair<Structure<?>, T>>> weightedStructureInfos = ArrayListMultimap.create();
    protected TObjectDoubleMap<C> totalWeights = new TObjectDoubleHashMap();

    public StructureSelector(Map<String, Structure<?>> structures, WorldProvider provider, Biome biome, Class<T> typeClass) {
        this.cachedDimensionTypes.addAll(DimensionDictionary.getDimensionTypes(provider));
        for (Map.Entry<String, Structure<?>> entry : structures.entrySet()) {
            float tweaked = RCConfig.tweakedSpawnRate(entry.getKey());
            for (GenerationType selection : entry.getValue().generationTypes(typeClass)) {
                double generationWeight = ((EnvironmentalSelection)((Object)selection)).getGenerationWeight(provider, biome) * (double)tweaked;
                if (!(generationWeight > 0.0)) continue;
                this.weightedStructureInfos.put(((EnvironmentalSelection)((Object)selection)).generationCategory(), (Object)new WeightedSelector.SimpleItem(generationWeight, (Object)Pair.of(entry.getValue(), (Object)selection)));
                this.totalWeights.adjustOrPutValue(((EnvironmentalSelection)((Object)selection)).generationCategory(), generationWeight, generationWeight);
            }
        }
    }

    public static double generationWeight(WorldProvider provider, Biome biome, PresettedList<WeightedBiomeMatcher> biomeWeights, PresettedList<WeightedDimensionMatcher> dimensionWeights) {
        return StructureSelector.generationWeightInBiome(biomeWeights, biome) * StructureSelector.generationWeightInDimension(dimensionWeights, provider);
    }

    public static double generationWeightInDimension(PresettedList<WeightedDimensionMatcher> dimensionWeights, WorldProvider provider) {
        for (WeightedDimensionMatcher generationInfo : (ArrayList)dimensionWeights.getContents()) {
            if (!generationInfo.matches(provider)) continue;
            return generationInfo.getActiveGenerationWeight();
        }
        return 0.0;
    }

    public static double generationWeightInBiome(PresettedList<WeightedBiomeMatcher> biomeWeights, Biome biome) {
        for (WeightedBiomeMatcher generationInfo : (ArrayList)biomeWeights.getContents()) {
            if (!generationInfo.matches(biome)) continue;
            return generationInfo.getActiveGenerationWeight();
        }
        return 0.0;
    }

    public double totalWeight(@Nonnull C c) {
        return this.totalWeights.get(c);
    }

    @Nullable
    public Pair<Structure<?>, T> selectOne(Random random, @Nonnull C c) {
        return this.selectOne(random, c, this.totalWeight(c));
    }

    @Nullable
    public Pair<Structure<?>, T> selectOne(Random random, @Nonnull C c, double totalWeight) {
        return totalWeight > 0.0 ? (Pair)WeightedSelector.select((Random)random, (Collection)this.weightedStructureInfos.get(c)) : null;
    }

    public boolean isValid(Biome biome, WorldProvider provider) {
        return DimensionDictionary.getDimensionTypes(provider).equals(this.cachedDimensionTypes);
    }
}

